 ; Nail - install notes into a drawing.
 ; Copyright 1996, 2002 by Rocket Software Ltd.
 ; 

 ; Whilin - draw text until nothing is entered after the initial number
 ; entity, then erase that and quit.
 (DEFUN WHILIN (pa num / goon dimscl hght enam)
  (setq num (1- num))
  (malaya "text")
  (setq dimscl (getvar "dimscale"))
  (setq hght (* 3 dimscl))
  (setq goon t)
  (while goon
         (command "text" pa hght "0" (strcat (itoa (setq num (1+ num))) "."))
         (setq enam (entlast))
         (setq pa (polar pa 0 (* 7 dimscl)))
         (command "dtext" pa hght "0")
         (if (equal (entlast) enam)
             (progn
                  (setq goon ())
                  (entdel enam))
             (progn
                  (setq pa (cdr (assoc 10 (entget (entlast)))))
                  (setq pa (polar pa pi (* 7 dimscl)))
                  (setq pa (polar pa (* pi 1.5) 7)))))
  (if (= (cdr (assoc 1 (entget (entlast)))) "%%UNOTES:")
      (entdel (entlast)))
 (princ))

 ; Subroutine N2 - continue below an existing N. string.
 (DEFUN N2 (pa num / dimscl)
  (setq dimscl (getvar "dimscale"))
  (setq pa (polar pa (* pi 1.5) (* 7 dimscl)))
  (whilin pa (1+ num))
 (princ))

 ; Subroutine N3 - continue below an existing text string.
 (DEFUN N3 (pa / num dimscl)
  (setq num (getint "\nNote number: "))
  (setq dimscl (getvar "dimscale"))
  (setq pa (polar pa pi (* 7 dimscl)))
  (setq pa (polar pa (* pi 1.5) (* 7 dimscl)))
  (whilin pa num)
 (princ))

 ; Subroutine Note - start the note text.
 (DEFUN NOTE (pa / hght dimscl num)
  (malaya "text")
  (setq hght (* 4 (setq dimscl (getvar "dimscale"))))
  (command "text" pa hght "0" "%%UNOTES:")
  (setq pa (polar pa (* pi 1.5) (* 8 dimscl)))
  (setq num 1)
  (whilin pa num)
 (princ))

 ; Nail - the all-purpose fastener.
 (DEFUN C:NAIL (/ pa nent entt ten str num)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq pa (getpoint "Start point or previous line: "))
  (if (and (setq nent (nentselp pa))
           (setq entt (entget (car nent)))
           (= (cdr (assoc 0 entt)) "TEXT"))
      (progn
           (setq ten (cdr (assoc 10 entt)))
           (setq str (cdr (assoc 1 entt)))))
  (cond ((and str
              (>= (strlen str) 2)
              (numberp (setq num (read (substr str 1 1))))
              (= (substr str 2 1) "."))
         (n2 ten num))
        (str (n3 ten))
        (t (note pa)))
 (princ))